# Photoshop Scripts for TinyPNG and TinyJPEG

These JavaScripts that can be added to Photoshop to help with compressing JPEG
and PNG Images using the TinyPNG & TinyJPG Photoshop plugin.

For more information about the Photoshop plugin you can visit
[tinypng.com/photoshop](https://tinypng.com/photoshop).

## Installation

The scripts may be copied to the 'Presets/Scripts' folder in Adobe Photoshop.

This is usually found in the following locations:

```
Mac: 
- /Applications/Adobe Photoshop (version)/Presets/Scripts/
- ~/Library/Application Support/Adobe/Adobe Photoshop (version)/Presets/Scripts
Windows:
- C:\Program Files\Adobe\Adobe Photoshop (version)\Presets\Scripts\
```

## Usage

New menu options will appear in the 'File' menu. The scripts will be executed
by simply selecting them.

```
File >
  Automate >
    Compress File...
    Compress Folder with JPEG Images...
    Compress Folder with PNG Images...
  Scripts >
    Layer Comps to Tinify...
```

## Create your own

The scripts are written in JavaScript. You can easily create your own based on
these examples. Photoshop also comes with many build-in scripts which you can
look at to give more ideas of what is possible. If you are interested in
scripting in more detail you can also take a look at the blog article which
shows an example of how to
[compress all images in a folder](http://voormedia.com/blog/2014/06/compressing-png-images-in-photoshop-with-javascript-and-tinypng)
with JavaScript.

## License

This software is licensed under the MIT License. [View the license](LICENSE).
